Attribute VB_Name = "MdlIniFile"
Option Explicit

Declare Function WritePrivateProfileString Lib "KERNEL32.DLL" Alias "WritePrivateProfileStringA" ( _
    ByVal lpAppName As String, _
    ByVal lpKeyName As Any, _
    ByVal lpString As Any, _
    ByVal lpFileName As String) As Long

Declare Function GetPrivateProfileString Lib "KERNEL32.DLL" Alias "GetPrivateProfileStringA" ( _
    ByVal lpAppName As String, _
    ByVal lpKeyName As Any, _
    ByVal lpDefault As String, _
    ByVal lpReturnedString As String, _
    ByVal nSize As Long, _
    ByVal lpFileName As String) As Long

Declare Function GetPrivateProfileInt Lib "KERNEL32.DLL" Alias "GetPrivateProfileIntA" ( _
    ByVal lpAppName As String, _
    ByVal lpKeyName As String, _
    ByVal nDefault As Long, _
    ByVal lpFileName As String) As Long
'
Declare Function PathRemoveFileSpec Lib "SHLWAPI.DLL" Alias "PathRemoveFileSpecA" ( _
    ByVal pszPath As String) As Long

Declare Function PathFindFileName Lib "SHLWAPI.DLL" Alias "PathFindFileNameA" ( _
    ByVal pszPath As String) As Long

Declare Sub MoveMemory Lib "kernel32" Alias "RtlMoveMemory" ( _
    pDest As Any, pSource As Any, ByVal ByteLen As Long)

Private Const MAX_PATH = 260
Private Const INI_FILE As String = ".\ANT_Para.ini"

'*****************************************
'   Only API file pathname is taken out.
'*****************************************
Public Function RemoveFileSpec(ByVal strPath As String) As String
    ' strPath : full path(path name and file name)
    ' return  : paht name

    Dim lngResult As Long
    lngResult = PathRemoveFileSpec(strPath)
    If lngResult <> 0 Then
        If 0 < InStr(strPath, vbNullChar) Then
            RemoveFileSpec = Left$(strPath, InStr(strPath, vbNullChar) - 1)
        Else
            RemoveFileSpec = strPath
        End If
    End If
End Function

'********************************************
' Writes Board Number in ANT_Para.ini
'********************************************
Public Sub WriteIniFile_BD(ByVal BdNo As String)
    Dim ret As Long
    ret = WritePrivateProfileString("Board", "Number", BdNo, INI_FILE)
End Sub
'*********************************************
' Reads Board Number from ANT_Para.ini
'*********************************************
Public Function ReadIniFile_BD() As String
    Dim strSb As String
    Dim ret As Long
    
    strSb = "  "
    ret = GetPrivateProfileString("Board", "Number", "0", strSb, Len(strSb), INI_FILE)
    strSb = Replace(strSb, Chr(0), "")
    ReadIniFile_BD = strSb
End Function


'********************************************
' Writes IP Address in ANT_Para.ini
'********************************************
Public Sub WriteIniFile_IP_Adrs(ByVal Adrs As String)
    Dim ret As Long
    ret = WritePrivateProfileString("IP", "Address", Adrs, INI_FILE)
End Sub
'*********************************************
' Reads IP Address from ANT_Para.ini
'*********************************************
Public Function ReadIniFile_IP_Adrs() As String
    Dim strAdrs As String
    Dim ret As Long
    
    strAdrs = "                "
    ret = GetPrivateProfileString("IP", "Address", "127.0.0.1", strAdrs, Len(strAdrs), INI_FILE)
    strAdrs = Replace(strAdrs, Chr(0), "")
    ReadIniFile_IP_Adrs = strAdrs
End Function


'***********************************************
' Writes Setup File Dialog path in ANT_Para.ini
'***********************************************
Public Sub WriteIniFile_SetupFileDlgPath(ByVal strFileDlgPath As String)
    Dim ret As Long
    ret = WritePrivateProfileString("FileDialog", "SetupPath", strFileDlgPath, INI_FILE)
End Sub
'**********************************************
' Reads Setup File Dialog path in ANT_Para.ini
'**********************************************
Public Function ReadIniFile_SetupFileDlgPath() As String
    Dim strPath As String
    Dim ret As Long
    
    strPath = Replace(Space(512), " ", Chr(0))
    ret = GetPrivateProfileString("FileDialog", "SetupPath", App.path, strPath, Len(strPath), INI_FILE)
    strPath = Replace(strPath, Chr(0), "")
    ReadIniFile_SetupFileDlgPath = strPath
End Function


'*************************************************
' Writes Ext Trigger Wait Pattern in ANT_Para.ini
'*************************************************
Public Sub WriteIniFile_ExtTriggerPttn(ByVal strPattern As String)
    Dim ret As Long
    ret = WritePrivateProfileString("ExtTrigger", "Pattern", strPattern, INI_FILE)
End Sub
'************************************************
' Reads Ext Trigger Wait Pattern in ANT_Para.ini
'************************************************
Public Function ReadIniFile_ExtTriggerPttn() As String
    Dim strPattern As String
    Dim ret As Long
    
    strPattern = "   "
    ret = GetPrivateProfileString("ExtTrigger", "Pattern", "0", strPattern, Len(strPattern), INI_FILE)
    strPattern = Replace(strPattern, Chr(0), "")
    ReadIniFile_ExtTriggerPttn = strPattern
End Function


'**************************************************************
' Writes Judge Display ON/OFF Check Box Status in ANT_Para.ini
'**************************************************************
Public Sub WriteIniFile_JudgeDisplay(ByVal JdgSts As String)
    Dim ret As Long
    ret = WritePrivateProfileString("Judge", "Display", JdgSts, INI_FILE)
End Sub
'****************************************************************
' Reads Judge Display ON/OFF Check Box Status  from ANT_Para.ini
'****************************************************************
Public Function ReadIniFile_JudgeDisplay() As String
    Dim strJdgSts As String
    Dim ret As Long
    
    strJdgSts = "  "
    ret = GetPrivateProfileString("Judge", "Display", "1", strJdgSts, Len(strJdgSts), INI_FILE)
    strJdgSts = Replace(strJdgSts, Chr(0), "")
    ReadIniFile_JudgeDisplay = strJdgSts
End Function


'***********************************************
' Writes Judge Display Position in ANT_Para.ini
'***********************************************
Public Sub WriteIniFile_JudgeDispPosi(ByVal JdgSts As String)
    Dim ret As Long
    ret = WritePrivateProfileString("Judge", "DispPosi", JdgSts, INI_FILE)
End Sub
'************************************************
' Reads Judge Display Position from ANT_Para.ini
'************************************************
Public Function ReadIniFile_JudgeDispPosi() As String
    Dim strJdgPosi As String
    Dim ret As Long
    
    strJdgPosi = "  "
    ret = GetPrivateProfileString("Judge", "DispPosi", CStr(LBL_JUDG_POSI4), strJdgPosi, Len(strJdgPosi), INI_FILE)
    strJdgPosi = Replace(strJdgPosi, Chr(0), "")
    ReadIniFile_JudgeDispPosi = strJdgPosi
End Function


'********************************************
' Writes Judge Font Size in ANT_Para.ini
'********************************************
Public Sub WriteIniFile_JdgFontSize(ByVal strJdgFontSize As String)
    Dim ret As Long
    ret = WritePrivateProfileString("Judge", "FontSize", strJdgFontSize, INI_FILE)
End Sub
'*********************************************
' Reads Judge Font Size from ANT_Para.ini
'*********************************************
Public Function ReadIniFile_JdgFontSize() As String
    Dim strJdgFontSize As String
    Dim ret As Long
    
    strJdgFontSize = "   "
    ret = GetPrivateProfileString("Judge", "FontSize", "0", strJdgFontSize, Len(strJdgFontSize), INI_FILE)
    strJdgFontSize = Replace(strJdgFontSize, Chr(0), "")
    ReadIniFile_JdgFontSize = strJdgFontSize
End Function


'***********************************************
' Writes Result Display Position in ANT_Para.ini
'***********************************************
Public Sub WriteIniFile_RsltDispPosi(ByVal JdgSts As String)
    Dim ret As Long
    ret = WritePrivateProfileString("Result", "DispPosi", JdgSts, INI_FILE)
End Sub
'************************************************
' Reads Result Display Position from ANT_Para.ini
'************************************************
Public Function ReadIniFile_RsltDispPosi() As String
    Dim strRsltPosi As String
    Dim ret As Long
    
    strRsltPosi = "  "
    ret = GetPrivateProfileString("Result", "DispPosi", CStr(LBL_RSLT_POSI1), strRsltPosi, Len(strRsltPosi), INI_FILE)
    strRsltPosi = Replace(strRsltPosi, Chr(0), "")
    ReadIniFile_RsltDispPosi = strRsltPosi
End Function


'********************************************
' Writes Result Font Size in ANT_Para.ini
'********************************************
Public Sub WriteIniFile_RsltFontSize(ByVal strJdgFontSize As String)
    Dim ret As Long
    ret = WritePrivateProfileString("Result", "FontSize", strJdgFontSize, INI_FILE)
End Sub
'*********************************************
' Reads Result Font Size from ANT_Para.ini
'*********************************************
Public Function ReadIniFile_RsltFontSize() As String
    Dim strRsltFontSize As String
    Dim ret As Long
    
    strRsltFontSize = "   "
    ret = GetPrivateProfileString("Reult", "FontSize", "0", strRsltFontSize, Len(strRsltFontSize), INI_FILE)
    strRsltFontSize = Replace(strRsltFontSize, Chr(0), "")
    ReadIniFile_RsltFontSize = strRsltFontSize
End Function


'******************************************************
' Writes Save Meas Data File Dialog path in ANT_Chk.ini
'******************************************************
Public Sub WriteIniFile_SvMsrDtFileDlgPath(ByVal strFileDlgPath As String)
    Dim ret As Long
    ret = WritePrivateProfileString("FileDialog", "SvMsrDtPath", strFileDlgPath, INI_FILE)
End Sub
'*****************************************************
' Reads Save Meas Data File Dialog path in ANT_Chk.ini
'*****************************************************
Public Function ReadIniFile_SvMsrDtFileDlgPath() As String
    Dim strPath As String
    Dim ret As Long
    
    strPath = Replace(Space(512), " ", Chr(0))
    ret = GetPrivateProfileString("FileDialog", "SvMsrDtPath", App.path, strPath, Len(strPath), INI_FILE)
    strPath = Replace(strPath, Chr(0), "")
    ReadIniFile_SvMsrDtFileDlgPath = strPath
End Function


'*****************************************************
' Writes Fail Data CSV File Save Mark in ANT_Para.ini
'*****************************************************
Public Sub WriteIniFile_FailMarkType(ByVal strFailMarkType As String)
    Dim ret As Long
    ret = WritePrivateProfileString("FailMarkType", "Type", strFailMarkType, INI_FILE)
End Sub
'*******************************************************
' Reads Fail Data CSV File Save Mark  from ANT_Para.ini
' "-" : Invalid
'*******************************************************
Public Function ReadIniFile_FailMarkType() As String
    Dim strFailMarkType As String
    Dim ret As Long
    
    strFailMarkType = "  "
    ret = GetPrivateProfileString("FailMarkType", "Type", "x", strFailMarkType, Len(strFailMarkType), INI_FILE)
    strFailMarkType = Replace(strFailMarkType, Chr(0), "")
    ReadIniFile_FailMarkType = strFailMarkType
End Function


'*****************************************************************
' Writes Fail Data CSV File Save State (frmSetup) in ANT_Para.ini
'*****************************************************************
Public Sub WriteIniFile_FailDtSvChkBx(ByVal strFailSv As String)
    Dim ret As Long
    ret = WritePrivateProfileString("FailSave", "State", strFailSv, INI_FILE)
End Sub
'*******************************************************************
' Reads Fail Data CSV File Save State (frmSetup)  from ANT_Para.ini
'*******************************************************************
Public Function ReadIniFile_FailDtSvChkBx() As String
    Dim strFailSv As String
    Dim ret As Long
    
    strFailSv = "   "
    ret = GetPrivateProfileString("FailSave", "State", "0", strFailSv, Len(strFailSv), INI_FILE)
    strFailSv = Replace(strFailSv, Chr(0), "")
    ReadIniFile_FailDtSvChkBx = strFailSv
End Function


'***************************************************
' Writes Cal File Read Check ON/OFF in ANT_Para.ini
'***************************************************
Public Sub WriteIniFile_CalReadChk(ByVal strCalReadChk As String)
    Dim ret As Long
    ret = WritePrivateProfileString("CalRead", "Check", strCalReadChk, INI_FILE)
End Sub
'*********************************************************
' Reads Fail Cal File Read Check ON/OFF from ANT_Para.ini
'*********************************************************
Public Function ReadIniFile_CalReadChk() As String
    Dim strCalReadChk As String
    Dim ret As Long
    
    strCalReadChk = "  "
    ret = GetPrivateProfileString("CalRead", "Check", "1", strCalReadChk, Len(strCalReadChk), INI_FILE)
    strCalReadChk = Replace(strCalReadChk, Chr(0), "")
    ReadIniFile_CalReadChk = strCalReadChk
End Function


'*****************************************
' Writes Tool Menu ON/OFF in ANT_Para.ini
'*****************************************
Public Sub WriteIniFile_ToolMenu(ByVal strCalReadChk As String)
    Dim ret As Long
    ret = WritePrivateProfileString("ToolMenu", "Valid", strCalReadChk, INI_FILE)
End Sub
'******************************************
' Reads Tool Menu ON/OFF from ANT_Para.ini
'******************************************
Public Function ReadIniFile_ToolMenu() As String
    Dim strToolMenuChk As String
    Dim ret As Long
    
    strToolMenuChk = "  "
    ret = GetPrivateProfileString("ToolMenu", "Valid", "0", strToolMenuChk, Len(strToolMenuChk), INI_FILE)
    strToolMenuChk = Replace(strToolMenuChk, Chr(0), "")
    ReadIniFile_ToolMenu = strToolMenuChk
End Function

